/******************************************************************************/
class SlidingDoor : Game.Animatable
{
public:
   
    SlidingDoor();
   ~SlidingDoor();
   
   virtual void create(Object &obj);
   virtual bool update();
   virtual uint drawPrepare();
   
   // Will start the animation to open/close the door
   void Open();
   void Close();
   
   void SetLocked(bool locked) { m_Locked = locked; }
   
private:

   bool m_Opening, m_Locked;
   flt m_AnimTimer, m_AnimSpeed;
};
/******************************************************************************/
SlidingDoor::SlidingDoor() : m_Opening(false), m_AnimTimer(0), m_AnimSpeed(2), m_Locked(false)
{
 
}
SlidingDoor::~SlidingDoor()
{
   
}
/******************************************************************************/
void SlidingDoor::create(Object &obj)
{
   super.create(obj);
   
   if(Param* p = obj.findParam("Locked")) m_Locked = p.asBool();
}
/******************************************************************************/
bool SlidingDoor::update()
{
   // When the door is being opened, we increment a timer. This timer is used to progress the animation.
   // When the door is no longer being opened, we decrease the same timer to close the door again
   if(m_Locked) m_Opening = false; // If the door locks, let the door go down
   else if(m_Opening &&  m_AnimTimer < skel_anim.length()) m_AnimTimer += Time.d() * m_AnimSpeed; // Door is opening
   
   // Door can still play the closing animation if it's locked
   if(!m_Opening && m_AnimTimer > 0) m_AnimTimer -= Time.d() * m_AnimSpeed; // Door is closing
    
   skel.clear().animate(skel_anim, m_AnimTimer).updateMatrix(_matrix).updateVelocities(); // Update animation
   actor.pos(skel.pos() + skel.boneRoot(0).pos); // Update physics
    
   return true;
}
uint SlidingDoor::drawPrepare()
{
   // Draw a red or green light, depending on m_Locked   
   Vec color = m_Locked ? Vec(1, 0, 0) : Vec(0, 1, 0);
   
   // Those slots are defined in the model editor. You can freely move those to any position you like
   LightPoint(0.04, skel.getSlot(Str8("AccessLight1")).pos, color).add();
   LightPoint(0.04, skel.getSlot(Str8("AccessLight2")).pos, color).add();
   
   return super.drawPrepare();
}
/******************************************************************************/
void SlidingDoor::Open()
{
   // Door is set to be opening, this only works if it's not locked
   if(!m_Locked)
   {
      m_Opening = true;  
   }
}
void SlidingDoor::Close()
{
   m_Opening = false;
}
