// StaticToggleable allows the same functionality as Static, and added:
// Toggle hiding/drawing
/******************************************************************************/
class StaticToggleable : Game.Static
{
public:
   
    StaticToggleable ();
   ~StaticToggleable();
   
   virtual void create(Object &obj);
   virtual bool update();
   virtual uint drawPrepare();
   virtual void drawShadow ();
   
   void SetDraw(bool draw);
   
private:
      
   bool m_Draw;
};
/******************************************************************************/
StaticToggleable::StaticToggleable() : m_Draw(true)
{

}
StaticToggleable::~StaticToggleable()
{
   
}
/******************************************************************************/
void StaticToggleable::create(Object &obj)
{
   if(Param *p = obj.findParam("Draw")) m_Draw = p.asBool(); 
   
   super.create(obj);
   
   SetDraw(m_Draw);
}
/******************************************************************************/
bool StaticToggleable::update()
{
   if(!m_Draw) return true; // Not updating, but also not deleting
   
   return super.update();
}
/******************************************************************************/
uint StaticToggleable::drawPrepare()
{
   if(m_Draw) return super.drawPrepare();
   
   return 0;
}
/******************************************************************************/
void StaticToggleable::drawShadow()
{
   if(m_Draw) super.drawShadow();
}
/******************************************************************************/
void StaticToggleable::SetDraw(bool draw)
{
   m_Draw = draw;
   actor.active(m_Draw); 
   actor.sleep(m_Draw);
}
