/******************************************************************************/
class Item : Game.Animatable
{
public:
   
            Item();
   virtual ~Item();
   
   virtual void create(Object &obj);
   virtual void AfterCreate(      );
   virtual bool update();
   virtual uint drawPrepare();
   
   void PickedUp();
   
private:
      
   bool m_Pickedup, m_FirstTick;
   ENUM_ITEMTYPES m_Type;
   UID m_EventsID; // ID to the EventGroup. Once the item has been picked up, it will call all the linked events through this group.
   EventGroup* m_PickedUpEventGroup;
};
/******************************************************************************/
Item::Item() : m_Pickedup(false), m_FirstTick(true)
{
   
}
Item::~Item()
{
   
}
/******************************************************************************/
void Item::create(Object &obj)
{
   super.create(obj);
   
   if(Param *p = obj.findParam("Type"))          m_Type     = (ENUM_ITEMTYPES)p.asEnum();
   if(Param *p = obj.findParam("EventGroupUID")) m_EventsID =                 p.asID();
}
/******************************************************************************/
void Item::AfterCreate()
{
   m_PickedUpEventGroup = GetEventGroupForID(m_EventsID);
}
/******************************************************************************/
bool Item::update()
{
   // On the first frame, call AfterCreate(). This method allows you to initialize all events/objects that need to be called/referenced
   if(m_FirstTick)
   {
      AfterCreate();
      
      m_FirstTick = false;
   }
   
   // Item has been picked up, remove from the world
   if(m_Pickedup) return false;
   
   return super.update();
}
/*****************************************************************************/
uint Item::drawPrepare()
{
   // Highlight this object when the user is hovering over it   
   SetHighlight((interaction.obj == this && interaction.highlight) ? Color(34,85,85) : Color(0,0,0)); 
   UInt modes = super::drawPrepare();
   SetHighlight(Color(0,0,0)); // Apply highlight only to this object, not to anything we will still draw after this
   
   return modes;
}
/******************************************************************************/
void Item::PickedUp()
{
   m_Pickedup = true;
   
   // Examples:
   // Do specific things depending on the item type
   //     if(m_Type == ITEM_ONE) Players[0].PickedUpItemOne();
   //else if(m_Type == ITEM_TWO) DoSomething();
   
   // Call the EventGroup linked to this Item
   m_PickedUpEventGroup.Triggered();
}
