/******************************************************************************/
class ControlElevator : BaseEvent
{
public:
            ControlElevator();
   virtual ~ControlElevator();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   UID m_PlatformID;
   Elevator* m_Elevator;
   Vec m_GoalPos, m_OrigPos;
   flt m_Speed;
};
/******************************************************************************/
ControlElevator::ControlElevator() : BaseEvent(), m_Speed(0), m_GoalPos(0), m_OrigPos(0), m_Elevator(null)                       
{
   
}
ControlElevator::~ControlElevator()
{
   
}
/******************************************************************************/
void ControlElevator::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("GoalPos"))     m_GoalPos    = p.asVec();
   if(Param *p = obj.findParam("PlatformUID")) m_PlatformID = p.asID();
   if(Param *p = obj.findParam("Speed"))       m_Speed      = p.asFlt();  
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void ControlElevator::AfterCreate()
{
   // Find the correct Elevator to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(elevators)
      if(elevators[i].id() == m_PlatformID)
            m_Elevator = &elevators[i]; 
            
   DEBUG_ASSERT(m_Elevator, "Elevator not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void ControlElevator::CallTriggeredAction()
{
   // move the elevator
   m_OrigPos = m_Elevator->pos();
   m_Elevator->Activate(m_GoalPos, m_Speed);
   
   if(m_LogDetailed)
   {
      LogN(S+"Start Trigger: Moving platform (INFO: " + m_Elevator->m_EditorInfo + " ) from: " + m_OrigPos.asText() + ", to: " + m_GoalPos.asText() + ", with speed: " + m_Speed);
   }
   else if(m_LogOutput)
   {
      LogN(S+"Start Trigger: Moving platform (INFO: " + m_Elevator->m_EditorInfo + " )");
   }
}

// This method is called when the duration of the event has been reached
void ControlElevator::StopTriggeredAction()
{
   // If m_Duration is not -1, the elevator will move back again after a while
   m_Elevator->Activate(m_OrigPos, m_Speed);
   /*
   if(m_LogDetailed)
   {
      LogN(S+" Stop Trigger: Moving platform (INFO: " + m_Elevator->m_EditorInfo + " ) from: " + m_Elevator->pos().asText() + ", to: " + m_OrigPos.asText() + ", with speed: " + m_Speed);
   }
   else if(m_LogOutput)
   {
      LogN(S+" Stop Trigger: Moving platform (INFO: " + m_Elevator->m_EditorInfo + " )");
   }*/ 
}
/******************************************************************************/